use strict;

my @displays = ();
my %includeFiles = ();
my %keyFields = ();

my $filename = shift or die ("No filename specified");

open MODULE, "< $filename" or die ("Cannot open $filename: $!");

while (<MODULE>)
{
    next unless /^(#{{|\d\d\d) ?(.*)$/;
    
    my ($code, $data) = ($1, $2);
    
    if ($code eq "002")
    {
        parseCustomLine($data);
    }
    elsif ($code eq "004")
    {
        parseIncludeFile($data);
    }
    elsif ($code eq "#{{")
    {
        if ($data =~ /^(.+):\s+([^s].*)$/)
        {
            $keyFields{$1} = $2;   
        }
    }
}

close MODULE;

foreach (@displays)
{
    print "Display " . $_->{"Title"} . "\n";
    WriteDisplay($_);
}

foreach (keys %includeFiles)
{
    print "File $_\n";
    WriteIncludeFile($_);
}

foreach (sort keys %keyFields)
{
    print "$_ -> $keyFields{$_}\n";
}

sub WriteIncludeFile
{
    my $name = shift;
    my $file = $includeFiles{$name};
    
    mkdir ("Include Files", 0666) unless ( -d "Include Files" );
    
    open FILE, "> Include Files/$name.txt" or die ("Include Files/$name.txt: $!");
    
    for (@{$file->{"File"}})
    {
        print FILE "$_\n";
    }
    
    close FILE;

    #if (@{$file->{"ACL"}} > 0)
    #{
    #    open ACL, "> Include Files/$name.acl.txt" or die ("Include Files/$name.acl.txt: $!");
    #    
    #    for (@{$file->{"ACL"}})
    #    {
    #        print ACL "$_\n";
    #    }
    #    
    #    close ACL;
    #}
}

sub WriteDisplay
{
    my $display = shift;
    my $dirname = $display->{"Title"};
    
    $dirname =~ s|[&:/\\*?\|_\. <>]+| |g;
    $dirname =~ s/^\s+//;
    $dirname =~ s/\s+$//;
    $dirname = "Displays/$dirname";

    mkdir ("Displays", 0666) unless ( -d "Displays" );
    mkdir $dirname, 0666;
    
    open COLS, "> $dirname/columns.txt" or die ("$dirname/columns.txt: $!");
    for (@{$display->{"Columns"}}) 
        { print COLS $_->{"Code"} . " " . $_->{"Title"} . "\n"; }
    close COLS;
    
    my @files = (
        "Main NT", "Main Unix", "Main VMS", "Post-processing", "Pre-processing",
        "Common NT", "Common Unix", "Common VMS", "Startup", "Main AS400", 
        "Main MVS", "Main Tandem", "Common AS400", "Common MVS", 
        "Common Tandem", "Comment", "Service Display Description");

    for (@files)
    {
        open FILE, "> $dirname/$_.txt" or die ("$dirname/$_.txt: $!");
        for (@{$display->{$_}}) { print FILE "$_\n"; }
        close FILE;        
    }

    open FILE, "> $dirname/Parameters.txt" or die ("$dirname/Parameters.txt: $!");
    for (@{$display->{"Parameters"}}) { print FILE $_->{"Code"} . ": " . $_->{"Title"} . "\n"; }
    close FILE;

    for (@{$display->{"Menus"}})
    {
        my $menu = $_;
        my $folder = $display->{"Menu Indices"}[$menu->{"IdxMenu"} - 1];
        $folder =~ s/^(\d )?//;

        my $title = (($folder ne "") ? "$folder :: " : "") . $menu->{"Title"};
        $title =~ s/&//g;
        $title =~ s|[&:/\\*?\|\. ]|_|g;
        $title =~ s/^\s+//;
        $title =~ s/\s+$//;

        my $dir = "$dirname/$title";

        my @scripts = ("Description", "Script NT", 
                    "Script Unix", "Script VMS", "Script Fields", 
                    "Script Post", "Script Pre", "Script Tandem", 
                    "Script MVS", "Script Controls", "Script AS400", 
                    "Init AS400", "Init MVS", "Init NT", "Init Post", 
                    "Init Pre",  "Init Unix", "Init VMS", "Init Tandem");

        mkdir $dir, 0666;

        for (@scripts)
        {
            open FILE, "> $dir/$_.txt" or die ("$dir/$_.txt: $!");
            for (@{$menu->{$_}}) { print FILE "$_\n"; }
            close FILE;        
        }

        open FILE, "> $dir/fields.txt" or die ("$dir/fields.txt: $!");
        for (@{$menu->{"Fields"}}) { print FILE $_->{"Code"} . ": " . $_->{"Title"} . "\n"; }
        close FILE;
    }
}

###
#
#   Parser Subroutines
#
###

{
    my $cDisp;
    my $cColm;
    my $cMenu;
    my $cMFld;
    my $cPFld;
    my $cLout;
 
    my %fSingleDisp;
    my %fArrayDisp;
    my %fColm;
    my %fSingleMenu;
    my %fArrayMenu;
    my %fSingleMFld;
    my %fArrayMFld;
    my %fSinglePFld;
    my %fArrayPFld;
    my %fSingleLout;
    my %fArrayLout;
    
    my %unknowns;
    
    BEGIN {
        %fSingleDisp = (101 => "Title", 106 => "Folder", 113 => "Custom Code",
                        121 => "Refresh", 129 => "Can Edit?", 151 => "Font",
                        152 => "Background", 153 => "Text", 154 => "Grid",
                        156 => "Grid?", 157 => "Alternate Bars", 
                        158 => "Extra Height", 159 => "Fill Background",
                        260 => "Rows Per Bar", 150 => "Custom Appearance",
                        140 => "Data Cache?", 141 => "Cache Valid Days",
                        142 => "Cached Fields", 130 => "Drag Source?",
                        131 => "Drop Target?", 132 => "Drag Displays",
                        167 => "Service Display", 168 => "Multiple Service",
                        161 => "NT Seal", 162 => "Unix Seal", 163 => "VMS Seal",
                        164 => "AS/400 Seal", 165 => "MVS Seal", 
                        166 => "Tandem Seal");
                           
        %fArrayDisp  = (102 => "Comment", 103 => "Main NT", 104 => "Main Unix",
                        105 => "Main VMS", 107 => "Post-processing", 
                        108 => "Pre-processing", 109 => "Common NT",
                        110 => "Common Unix", 111 => "Common VMS", 112 => "ACL",
                        122 => "Startup", 123 => "Main AS400", 
                        124 => "Main MVS", 125 => "Main Tandem", 
                        126 => "Common AS400", 127 => "Common MVS", 
                        128 => "Common Tandem", 301 => "Menu Indices",
                        169 => "Service Display Description");
                           
        %fColm = (201 => "Title", 202 => "Alignment", 203 => "Default?",
                  204 => "Display", 205 => "Code", 206 => "Sort", 
                  207 => "Unique?", 208 => "Tag", 209 => "Preserve" );
                  
        %fSingleMenu = (311 => "Title", 313 => "Apply",
                  336 => "Apply Field", 325 => "Confirm", 345 => "Default", 
                  346 => "Drop Entry", 321 => "IdxMenu", 322 => "IdxEntry",
                  361 => "NT Seal", 362 => "Unix Seal", 363 => "VMS Seal",
                  364 => "AS/400 Seal", 365 => "MVS Seal", 366 => "Tandem Seal",
                  367 => "NT Init Seal", 368 => "Unix Init Seal", 
                  369 => "VMS Init Seal", 370 => "AS/400 Init Seal", 
                  371 => "MVS Init Seal", 372 => "Tandem Init Seal",
                  358 => "Icon");
                  
        %fArrayMenu = (312 => "Description", 314 => "Script NT", 
                       315 => "Script Unix", 316 => "Script VMS", 331 => "ACL", 
                       330 => "Script Fields", 326 => "Script Post", 
                       327 => "Script Pre", 353 => "Script Tandem", 
                       352 => "Script MVS", 350 => "Script Controls",
                       351 => "Script AS400", 
                       354 => "Init AS400", 355 => "Init MVS", 337 => "Init NT",
                       338 => "Init Post", 339 => "Init Pre", 
                       340 => "Init Unix", 341 => "Init VMS", 
                       356 => "Init Tandem");
                       
        %fSingleMFld = (317 => "Code", 343 => "Colour", 323 => "Comment", 
                  344 => "Default", 332 => "Depends On", 347 => "Depends Value",
                  333 => "Mask", 334 => "Max Length", 324 => "Options", 
                  329 => "Page", 335 => "Position", 348 => "Size (Columns)", 
                  349 => "Size (Rows)", 357 => "Tag", 318 => "Title", 
                  320 => "Type", 319 => "Value");
                  
        %fArrayMFld = (342 => "Script");
        
        %fSingleLout = (501 => "Title");
        %fArrayLout  = (502 => "Codes");

        %fSinglePFld = (401 => "Code", 402 => "Title", 403 => "Value", 
                        404 => "Type", 405 => "Comment", 406 => "Options",
                        407 => "Tag", 
                        422 => "Position", 423 => "Mask", 424 => "Max Length",
                        425 => "Depends On",  427 => "Colour",
                        428 => "Default", 429 => "Size (Columns)", 
                        430 => "Size (Rows)", 431 => "Depends Value", 
                        432 => "Page");

        %fArrayPFld = (420 => "Start", 421 => "Prompt", 426 => "Script");
        
        my %newDisp = (); $cDisp = \%newDisp;
        my %newColm = (); $cColm = \%newColm;
        my %newMenu = (); $cMenu = \%newMenu;
        my %newMFld = (); $cMFld = \%newMFld;
        my %newPFld = (); $cPFld = \%newPFld;
        my %newLout = (); $cLout = \%newLout;
    }
    
    sub parseCustomLine
    {
        return unless $_[0] =~ /^(\d\d\d|@.@)( (.*))?$/;
        
        my ($code, $data) = ($1, $3);
        
        if ($code eq '@C@')
        {
            push (@{$cDisp->{"Columns"}}, $cColm);
            my %newCol = (); $cColm = \%newCol;            
        }
        elsif ($code eq '@D@')
        {
            push (@displays, $cDisp);
            my %newDisp = (); $cDisp = \%newDisp;
        }
        elsif ($code eq '@F@')
        {
            push (@{$cMenu->{"Fields"}}, $cMFld);
            my %newMFld = (); $cMFld = \%newMFld;            
        }
        elsif ($code eq '@L@')
        {
            push (@{$cDisp->{"Layouts"}}, $cLout);
            my %newLayout = (); $cLout = \%newLayout;
        }
        elsif ($code eq '@M@')
        {
            push (@{$cDisp->{"Menus"}}, $cMenu);
            my %newMenu = (); $cMenu = \%newMenu;            
        }
        elsif ($code eq '@P@')
        {
            push (@{$cDisp->{"Parameters"}}, $cPFld);
            my %newPFld = (); $cPFld = \%newPFld;            
        }
        elsif (exists $fSingleDisp{$code})
        {
            print("Display singleton $code is plural.\n") if (exists $cDisp->{$fSingleDisp{$code}});
            $cDisp->{$fSingleDisp{$code}} = $data;
        }
        elsif (exists $fArrayDisp{$code})
        {
            push(@{$cDisp->{$fArrayDisp{$code}}}, $data);
        }
        elsif (exists $fColm{$code})
        {
            print("Column singleton $code is plural.\n") if (exists $cColm->{$fColm{$code}});
            $cColm->{$fColm{$code}} = $data;
        }
        elsif ($fSingleMenu{$code} ne "")
        {
            print("Menu singleton $code is plural.\n") if (exists $cMenu->{$fSingleMenu{$code}});
            $cMenu->{$fSingleMenu{$code}} = $data;
        }
        elsif (exists $fArrayMenu{$code})
        {
            push(@{$cMenu->{$fArrayMenu{$code}}}, $data);
        }
        elsif (exists $fSingleMFld{$code})
        {
            print("Menu field singleton $code is plural.\n") if (exists $cMFld->{$fSingleMFld{$code}});
            $cMFld->{$fSingleMFld{$code}} = $data;
        }
        elsif (exists $fArrayMFld{$code})
        {
            push(@{$cMFld->{$fArrayMFld{$code}}}, $data);
        }
        elsif (exists $fSinglePFld{$code})
        {
            print("Parameter singleton $code is plural.\n") if (exists $cPFld->{$fSinglePFld{$code}});
            $cPFld->{$fSinglePFld{$code}} = $data;
        }
        elsif (exists $fArrayPFld{$code})
        {
            push(@{$cPFld->{$fArrayPFld{$code}}}, $data);
        }
        elsif (exists $fSingleLout{$code})
        {
            print("Layout singleton $code is plural.\n") if (exists $cLout->{$fSingleLout{$code}});
            $cLout->{$fSingleLout{$code}} = $data;
        }
        elsif (exists $fArrayLout{$code})
        {
            push(@{$cLout->{$fArrayLout{$code}}}, $data);
        }
        else
        {
            unless (exists $unknowns{$code})
            {
                $unknowns{$code} = 1;
                print "Unknown code $code.\n";
            }
        }
    }
}

{
    my $cName = "";
    my $cData = "";
    my $cACL  = "";
    
    BEGIN
    {
        my @newData = ();
        my @newACL  = (); 
        $cData = \@newData; $cACL = \@newACL; 
    }
    
    sub parseIncludeFile
    {
        return unless $_[0] =~ /^(\d\d\d|@)( (.*))?$/;
        
        my ($code, $data) = ($1, $3);
        
        if ($code eq "101")
        {
            $cName = $data;
        }
        elsif ($code eq "102")
        {
            push(@{$cData}, $data);
        }
        elsif ($code eq "103")
        {
            push(@{$cACL}, $data);
        }
        elsif ($code eq "\@")
        {
            $includeFiles{$cName}{"File"} = $cData;
            $includeFiles{$cName}{"ACL"}  = $cACL;
            my @newData = (); $cData = \@newData;
            my @newACL  = (); $cACL  = \@newACL;
        }
        else
        {
            print "Unknown include file code $code.\n";
        }
    }        
}